// *********************************************************************//
// CopyRight (C) 2001-2002 BY Alawi Hussain BaAqeel (abaaqeel@hotmail.com)
// ********************** F R E EP R O G R A M *********************//

if(typeof HTMLElement!="undefined" && ! HTMLElement.prototype.insertAdjacentElement) {
	HTMLElement.prototype.insertAdjacentElement = function
(where,parsedNode)
	{
		switch (where){
		case 'beforeBegin':
			this.parentNode.insertBefore(parsedNode,this)
			break;
		case 'afterBegin':
			this.insertBefore(parsedNode,this.firstChild);
			break;
		case 'beforeEnd':
			this.appendChild(parsedNode);
			break;
		case 'afterEnd':
			if (this.nextSibling)
this.parentNode.insertBefore(parsedNode,this.nextSibling);
			else this.parentNode.appendChild(parsedNode);
			break;
		}
	}

	HTMLElement.prototype.insertAdjacentHTML = function
(where,htmlStr)
	{
		var r = this.ownerDocument.createRange();
		r.setStartBefore(this);
		var parsedHTML = r.createContextualFragment(htmlStr);
		this.insertAdjacentElement(where,parsedHTML)
	}


	HTMLElement.prototype.insertAdjacentText = function
(where,txtStr)
	{
		var parsedText = document.createTextNode(txtStr)
		this.insertAdjacentElement(where,parsedText)
	}
}


var enableFilter = 1;
function poet_setDefaultVar() {
	poetDefaultFont = "tahoma,ms sans serif,verdana,arial,helvetica";
	poetType = "0",
	poetLine = "200%",
	poetAlign = "center",
	poetUse = "sp";
	poetLength = "0";
	poetFontName = "",
	poetFontSize = "4", //1 to 7
	poetFontColor = "red",
	poetFontBold = "",
	poetFontItalic = "";
	poetBackColor = "none",
	poetBackImage = "none";
	poetFilter = "";
	poetBorderStyle = "none",
	poetBorderWidth = "medium",
	poetBorderColor = "black";
	poetChar = "";
	poetSerialNum = "0",
	poetSerialNumColor = "";
}
var poetSpaceWidth, poetExtendWidth;
var poetToolFix, poetDiff;
var poetLetters1 = ""
var poetLetters2 = "";
var poetLetters3 = "";
function create_testWidth_table() {
	if (!document.getElementById("testWidth")) {
		var HTML = "<table border=1 width=0 style='visibility:hidden;position:absolute'>"
		HTML += "<tr><td id='testWidth' width=0 nowrap></td></tr>"
		HTML += "</table>"
		document.body.insertAdjacentHTML("afterBegin", HTML);
//        document.write(HTML);
	}
}
function poet_getValue(t, p) {
	if (!p)
	{return "";}
	var r = new RegExp("([ \"]|^)" + t + "[ ]*=[ ]*\"[^\"]*\"", "i");
	var m = p.match(r);
	if (!m) {
		r = new RegExp("([ \"]|^)" + t + "[ ]*=[ ]*[^\" ]*([ ]|$)", "i");
		m = p.match(r);
		if (!m)
		return "";
	}
	m = m[0];
	m = m.replace(/\"/gi,"");
	var i = m.search("=");
	return m.substring(i + 1);
}
function poet_getDefault(p, d) {
	p = poet_trim(p);
	return poet_trim((p?p:d));
}
function poet_setArg(arg) {
	var par;
	par = poet_getValue("font", arg) + ",,,,";
	par = par.split(",");
	poetFontName = poet_getDefault(par[0], poetFontName);
	poetFontSize = poet_getDefault(par[1], poetFontSize);
	poetFontColor = poet_getDefault(par[2], poetFontColor);
	poetFontBold = poet_getDefault(par[3], poetFontBold);
	poetFontItalic = poet_getDefault(par[4], poetFontItalic);
	par = poet_getValue("border", arg) + ",,";
	par = par.split(",");
	poetBorderStyle = poet_getDefault(par[0], poetBorderStyle);
	poetBorderWidth = poet_getDefault(par[1], poetBorderWidth);
	poetBorderColor = poet_getDefault(par[2], poetBorderColor);
	par = poet_getValue("num", arg) + ",";
	par = par.split(",");
	poetSerialNum = poet_getDefault(par[0], poetSerialNum);
	poetSerialNumColor = poet_getDefault(par[1], poetSerialNumColor);
	par = poet_getValue("type", arg);
	poetType = poet_getDefault(par, poetType);
	par = poet_getValue("line", arg);
	poetLine = poet_getDefault(par, poetLine);
	par = poet_getValue("align", arg);
	poetAlign = poet_getDefault(par, poetAlign);
	par = poet_getValue("use", arg);
	poetUse = poet_getDefault(par, poetUse).toLowerCase();
	par = poet_getValue("length", arg);
	poetLength = poet_getDefault(par, poetLength);
	if (poetLength > 200)
		poetLength = 200;
	par = poet_getValue("bkcolor", arg);
	poetBackColor = poet_getDefault(par, poetBackColor);
	par = poet_getValue("bkimage", arg);
	poetBackImage = poet_getDefault(par, poetBackImage);
	par = poet_getValue("char", arg);
	poetChar = poet_getDefault(par, poetChar);
	if (enableFilter) {
		par = poet_getValue("filter", arg);
		poetFilter = poet_getDefault(par, poetFilter);
	}
	var facesize = new Array("xx-small","x-small","small","medium","large","x-large","xx-large");
	if (poetFontSize < 1)
		poetFontSize = 1;
	else if (poetFontSize > 7)
		poetFontSize = 4;
	else
		poetFontSize = facesize[poetFontSize - 1];
	poetFontName += "," + poetDefaultFont;
	var testWidth = fetch_object("testWidth");
	testWidth.style.fontFamily = poetFontName;
	testWidth.style.fontSize = poetFontSize;
	testWidth.style.fontWeight = poetFontBold;
	testWidth.style.fontStyle = poetFontItalic;
}
function poet_trim(t) {
	t = t.replace(/^[ ]+/,"");
	t = t.replace(/[ ]+$/,"");
	return t;
}
function poet_textWidth(t) {
	var testWidth = fetch_object("testWidth");
	testWidth.innerHTML= t.replace(/ /g, "&nbsp;");
	return (testWidth.clientWidth - 2) * 0.75;
}
function poet_strReplace(t, s1, s2, c) {
	if (c <= 0)
		return;
	t=t.split(s1);
	var s="";
	for (var i=t.length-1;i>0;i--)
		if (c-->0)
		s = s2 + t[i] + s;
		else
		s = s1 + t[i] + s;
		s = t[0] + s;
		return s;
}
function poet_count(str, ch) {
	var c = 0;
	for (var i = 0; i < str.length; i++)
		c += (str.charAt(i) == ch);
	return c;
}
function poet_space(n) {
	if (n == 1)
		return " ";
	return" " + poet_space(n-1);
}
function poet_createExtend(t) {
	var alef = "";
	var s = "";
	var befor = "", ch = "";
	t = t.replace(//g,"@");
	for (i = 0; i < t.length; i++) {
	ch = t.charAt(i);
	if (poetLetters2.indexOf(ch.charAt(0)) != -1 || ch.charAt(0) == "") {
		if (befor != "")
			if (poetLetters1.indexOf(befor.charAt(0)) == -1 && poetLetters2.indexOf(ch.charAt(0)) != -1 & (befor.charAt(0) != "" || alef.indexOf(ch.charAt(0)) == -1))
			s += "^";
			befor = ch;
			s += ch;
	}
	else {
		s += ch;
		if (poetLetters3.indexOf(ch.charAt(0)) == -1)
		befor = "";
	}
}
	s = s.replace(/@/g,"");
	return s;
}
function poet_extend(n) {
	if (n <= 0)
		return "";
	if (n == 1)
		return "";
	return"" + poet_extend(n-1);
}

function poet_justifyBYextend(t, w) {
	var ex = 0, i, d, n, p, m;
	ex = poet_count(t, "^");
	if (ex == 0) return t;
		d = Math.floor((w - poet_textWidth(t.replace(/\^/g,""))) / poetExtendWidth);
		t = t.split(" ");
		n = 0;
	for (i = 0; i < t.length; i++)
		n += (t[i].indexOf("^") != -1);
		p = Math.floor(d / n);
		m = d % n;
	for (i = t.length-1; i >= 0; i--) {
		ex = poet_count(t[i], "^");
		if (ex == 0)
			continue;
	d = p + (m-- > 0);
n = Math.floor(d / ex);
if (n > 0)
t[i] = t[i].replace(/\^/g, "^" + poet_extend(n));
if (d % ex > 0)
t[i] = poet_strReplace(t[i], "^", "", d % ex);
}
t = t.join(" ");
t = t.replace(/\^/g, "");
return t;
}
function poet_justifyBYspace(t, w, dir) {
var sp = 0, i, d, tw, n;
sp = poet_count(t, " ");
if (sp != 0) {
d = Math.floor((w - poet_textWidth(t)) / poetSpaceWidth);
n = Math.floor(d / sp);
if (n > 0)
t = t.replace(/ /g, poet_space(n + 1));
if (d % sp > 0)
t = poet_strReplace(t, poet_space(n + 1), poet_space(n + 2), d % sp);
}
tw = w - poet_textWidth(t);
if (tw > 0) {
i = t.lastIndexOf(" ");
if (i == -1)
if (dir == 0)
return t;
else
i = ((dir==2)?-1:t.length-1);
tw -= poetDiff;
t = t.substr(0, i+1) + poetToolFix.replace(/letter-spacing:normal/,"letter-spacing:"+tw+"pt ") + t.substr(i+1);
}
return t;
}
function poet_justify(t, w, dir) {
if (poetUse == "ex") t = poet_justifyBYextend(t, w);
return poet_justifyBYspace(t, w, dir);
}

function doPoetry(preview) {
	poet_setDefaultVar();
	//var d = fetch_object("DIV");
	var d = document.getElementsByTagName("DIV");
	var poetry = d[d.length-1].innerText;
	var arg = d[d.length-1].tag;
	var L, R, i, j, cr, MTW;
	var poetSide, poetSideNum;
	create_testWidth_table();
	poet_setArg(arg);
	poetToolFix = "<span style='font-size:1pt;letter-spacing:normal;visibility:hidden;'>ii</span>";
	var testWidth = fetch_object("testWidth");
	testWidth.innerHTML = poetToolFix;
	poetDiff = (testWidth.clientWidth - 2) * 0.75;
	poetToolFix = poetToolFix.replace(/ /g,"^");
	poetry = poetry.replace(/[\^@]/g,"");
	poetry = poetry.replace(/[ ]+/g," ");
	poetry = poetry.replace(/^[\r\n]+/,"");
	poetry = poetry.replace(/[\r\n]+$/,"");
	poetry = poetry.replace(/\n/g,"");
	poetry = poetry.replace(/[ ]*\r[ ]*/g,"\r");
	poetry = poetry.replace(/[ ]*=[ ]*/g,"=");
	poetry= poetry.replace(/^[ ]+/,"");
	poetry= poetry.replace(/[ ]+$/,"");
	poetry += "\r";
	poetExtendWidth = poet_textWidth("" + "" + "");
	poetExtendWidth -= poet_textWidth("" + "" + "");
	poetSpaceWidth = poet_textWidth("" + "&nbsp;&nbsp;" + "");
	poetSpaceWidth -= poet_textWidth("" + "&nbsp;" + "");
	if (poetUse=="ex") {
		var test = poet_textWidth(poetry);
		poetry = poet_createExtend(poetry);
		test = (poet_textWidth(poetry.replace(/\^/g, "")) - test) / poet_count(poetry,"^");
			if (test != poetExtendWidth) //problem in some fonts
				poetry = poetry.replace(/\^/g, "^");
	}
	testWidth.innerHTML = poetry.replace(/\r/g,"<br>").replace(/=/g,"<br>").replace(/ /g, "&nbsp;").replace(/\^/g, "");
	MTW = (testWidth.clientWidth - 2) * 0.75;
	if (parseFloat(poetLength) > MTW)
		MTW = parseFloat(poetLength);
	var nbsp = "&nbsp;&nbsp;&nbsp;&nbsp;";
	poetSideNum = "";
	poetSide = "";
	cr = 0;
	j = 0;
	var sn = 0;
	while (1) {
		cr = poetry.indexOf("\r", cr);
		if (cr == -1) break;
		if (poetry.substring(j, cr) != "") {
			i = poetry.indexOf("=", j);
			if (i == -1 || i > cr) i = cr; //no '=' in this line
			L = poetry.substring(j, i);
			L = poet_justify(L, MTW, ((i==cr)?0:1));
			L = L.replace(/ /g, "&nbsp;");
			L = L.replace(/\^/g, " ");
			R = poetry.substring(i+1, cr);
			R = poet_justify(R, MTW, 2);
			R = R.replace(/ /g, "&nbsp;");
			R = R.replace(/\^/g, " ");
			if (poetType == 0) {
				if (i != cr)
					poetSide += L + nbsp + poetChar + nbsp + R + "<br>";
				else
					poetSide += "<div align=center>" + L + "</div>";
				poetSideNum += ++sn + "<br>";
			}
            else if (poetType == 1) {
				if (i != cr) {
					poetSide += "<div style='margin-left:"+Math.round(MTW)+"pt'>" + L + "</div>";
					poetSide += "<div style='margin-right:"+Math.round(MTW)+"pt'>" + R + "</div>";
					poetSideNum += ++sn + "<br>&nbsp;<br>";
				}
                else {
				    poetSide += "<div align=center>" + L + "</div>";
					poetSideNum += ++sn + "<br>";
				}
            }
            else if (poetType == 2) {
				if (i != cr) {
					poetSide += "<div style='margin-left:"+Math.round(MTW/2)+"pt'>" + L + "</div>";
					poetSide += "<div style='margin-right:"+Math.round(MTW/2)+"pt'>" + R + "</div>";
					poetSideNum += ++sn + "<br>&nbsp;<br>";
				}
            	else {
					poetSide += "<div align=center>" + L + "</div>";
					poetSideNum += ++sn + "<br>";
				}
        	}
            else if (poetType == 3) {
					poetSideNum += ++sn + "<br>";
					poetSide += L + "<br>";
					if (i != cr) {
						poetSide += R + "<br>";
						poetSideNum += "&nbsp;<br>";
					}
            }
        }
        else {
			poetSide += "<br>";
			poetSideNum += "<br>";
		}
	cr += 1;
	j = cr;
	}
	poetSideNum = poetSideNum.replace(/(<br>)+$/i, "");
	poetSide = poetSide.replace(/(<br>)+$/i, "");
	var HTML = "", poetBodyStyle = "", poetSerialNumStyle = "";
	poetBodyStyle += ";font-family:" + poetFontName;
	poetBodyStyle += ";font-size:" + poetFontSize;
	poetBodyStyle += ";color:" + poetFontColor;
	poetBodyStyle += ";font-weight:" + poetFontBold;
	poetBodyStyle += ";font-style:" + poetFontItalic;
	poetBodyStyle += ";line-height:" + poetLine;
	poetBodyStyle += ";background-color:" + poetBackColor;
	poetBodyStyle += ";background-image:url(" + poetBackImage + ")";
	poetBodyStyle += ";border:" + poetBorderWidth + " " + poetBorderStyle + " " + poetBorderColor;
	poetSerialNumStyle = "color:" + poetSerialNumColor + "; display:" + ((poetSerialNum=="0")?"none":"block");
	HTML += "<div width=0 align='" + poetAlign + "'>";
	HTML += "<table dir=rtl border=0 cellspacing=10 cellpadding=5 onclick='poet_showhidenum(this)' width=0 class='poemstyle'>";
	HTML += "<tr>";
	HTML += "<td width=0 align=center valign=top style='" + poetSerialNumStyle + "' nowrap>";
	HTML += poetSideNum
	HTML += "</td>";
	HTML += "<td width=0 align=center valign=top nowrap class='poemstyle'><strong>";
	HTML += poetSide;
	HTML += "</strong></td>";
	HTML += "</tr></table></div>";
	if (preview)
		return HTML;
	else
		document.write(HTML);
}
function poet_showhidenum(o) {
	o = o.getElementsByTagName("TD")[0];
	if (o.style.display == "none") {
		o.style.display = "block";
    }
	else {
		o.style.display = "none";
	}
}

function PoetDialog(location) {
    var oSelect,oSelectRange;
    document.post.message.focus();
    oSelect = document.selection;
    oSelectRange = oSelect.createRange();
    var oSelText = oSelectRange;
    if (oSelText.parentElement().name == "message") {
      if (location == 'admin') {
	      showModalDialog("../bbcode_mod/hackpoet.htm",oSelText,"help:no; center:yes; status:no; dialogHeight:310px; dialogWidth:480px");
	  }
      else {
	      showModalDialog("bbcode_mod/hackpoet.htm",oSelText,"help:no; center:yes; status:no; dialogHeight:310px; dialogWidth:480px");
      }
	}
}